/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __lr10_dev_nvltlc_ip_h__
#define __lr10_dev_nvltlc_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_LO(i)                  (0x0000154c+(i)*0x54) /* RW-4A */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_LO__SIZE_1             4               /*       */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_LO_COUNT               31:0            /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_LO_COUNT_INIT          0x00000000      /* RWD-V */

#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_HI(i)                  (0x00001550+(i)*0x54) /* RW-4A */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_HI__SIZE_1             4               /*       */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_HI_COUNT               30:0            /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_HI_COUNT_INIT          0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_HI_ROLLOVER            31:31           /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_HI_ROLLOVER_INIT       0x00000000      /* RWD-V */

#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_LO(i)                  (0x00001d4c+(i)*0x54) /* RW-4A */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_LO__SIZE_1             4               /*       */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_LO_COUNT               31:0            /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_LO_COUNT_INIT          0x00000000      /* RWD-V */

#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_HI(i)                  (0x00001d50+(i)*0x54) /* RW-4A */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_HI__SIZE_1             4               /*       */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_HI_COUNT               30:0            /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_HI_COUNT_INIT          0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_HI_ROLLOVER            31:31           /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_HI_ROLLOVER_INIT       0x00000000      /* RWD-V */

#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0            0x00001a8c      /* RW-4R */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXDLHDRPARITYERR 0:0       /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXDLHDRPARITYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXDLHDRPARITYERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXDLDATAPARITYERR 1:1      /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXDLDATAPARITYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXDLDATAPARITYERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXDLCTRLPARITYERR 2:2      /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXDLCTRLPARITYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXDLCTRLPARITYERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXINVALIDAEERR 3:3         /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXINVALIDAEERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXINVALIDAEERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXINVALIDBEERR 4:4         /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXINVALIDBEERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXINVALIDBEERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXINVALIDADDRALIGNERR 5:5  /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXINVALIDADDRALIGNERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXINVALIDADDRALIGNERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXPKTLENERR 6:6            /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXPKTLENERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXPKTLENERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVCMDENCERR 7:7           /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVCMDENCERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVCMDENCERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVDATLENENCERR 8:8        /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVDATLENENCERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVDATLENENCERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVPKTSTATUSERR 9:9        /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVPKTSTATUSERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVPKTSTATUSERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVCACHEATTRPROBEREQERR 10:10 /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVCACHEATTRPROBEREQERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVCACHEATTRPROBEREQERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVCACHEATTRPROBERSPERR 11:11 /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVCACHEATTRPROBERSPERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSVCACHEATTRPROBERSPERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_DATLENGTRMWREQMAXERR 12:12 /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_DATLENGTRMWREQMAXERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_DATLENGTRMWREQMAXERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_DATLENLTATRRSPMINERR 13:13 /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_DATLENLTATRRSPMINERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_DATLENLTATRRSPMINERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_INVALIDCACHEATTRPOERR 14:14 /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_INVALIDCACHEATTRPOERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_INVALIDCACHEATTRPOERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_INVALIDCRERR 15:15         /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_INVALIDCRERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_INVALIDCRERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXRSPSTATUS_HW_ERR 16:16   /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXRSPSTATUS_HW_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXRSPSTATUS_HW_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXRSPSTATUS_UR_ERR 17:17   /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXRSPSTATUS_UR_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXRSPSTATUS_UR_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXRSPSTATUS_PRIV_ERR 18:18 /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXRSPSTATUS_PRIV_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_RXRSPSTATUS_PRIV_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_INVALID_COLLAPSED_RESPONSE_ERR 19:19 /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_INVALID_COLLAPSED_RESPONSE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_0_INVALID_COLLAPSED_RESPONSE_ERR_ENABLE 0x00000001 /* RW--V */

#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0            0x0000128c      /* RW-4R */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_TXDLCREDITPARITYERR 17:17  /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_TXDLCREDITPARITYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_TXDLCREDITPARITYERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_CREQ_RAM_HDR_ECC_DBE_ERR 18:18 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_CREQ_RAM_HDR_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_CREQ_RAM_HDR_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_CREQ_RAM_DAT_ECC_DBE_ERR 19:19 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_CREQ_RAM_DAT_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_CREQ_RAM_DAT_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_CREQ_RAM_ECC_LIMIT_ERR 20:20 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_CREQ_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_CREQ_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP_RAM_HDR_ECC_DBE_ERR 21:21 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP_RAM_HDR_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP_RAM_HDR_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP_RAM_DAT_ECC_DBE_ERR 22:22 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP_RAM_DAT_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP_RAM_DAT_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP_RAM_ECC_LIMIT_ERR 23:23 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_COM_RAM_HDR_ECC_DBE_ERR 24:24 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_COM_RAM_HDR_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_COM_RAM_HDR_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_COM_RAM_DAT_ECC_DBE_ERR 25:25 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_COM_RAM_DAT_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_COM_RAM_DAT_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_COM_RAM_ECC_LIMIT_ERR 26:26 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_COM_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_COM_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP1_RAM_HDR_ECC_DBE_ERR 27:27 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP1_RAM_HDR_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP1_RAM_HDR_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP1_RAM_DAT_ECC_DBE_ERR 28:28 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP1_RAM_DAT_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP1_RAM_DAT_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP1_RAM_ECC_LIMIT_ERR 29:29 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP1_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_0_RSP1_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */

#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1            0x00001aac      /* RW-4R */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_RXHDROVFERR 7:0            /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_RXHDROVFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_RXHDROVFERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_RXDATAOVFERR 15:8          /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_RXDATAOVFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_RXDATAOVFERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_STOMPDETERR 16:16          /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_STOMPDETERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_STOMPDETERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_RXPOISONERR 17:17          /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_RXPOISONERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_RXPOISONERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_HEARTBEAT_TIMEOUT_ERR 18:18 /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_HEARTBEAT_TIMEOUT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_HEARTBEAT_TIMEOUT_ERR_ENABLE 0x00000001 /* RW--V */

#define NV_NVLTLC_TX_LNK_ERR_STATUS_1                         0x000012a0      /* RW-4R */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC0         0:0             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC0_NONE    0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC0_CLEAR   0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC1         1:1             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC1_NONE    0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC1_CLEAR   0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC2         2:2             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC2_NONE    0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC2_CLEAR   0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC3         3:3             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC3_NONE    0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC3_CLEAR   0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC4         4:4             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC4_NONE    0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC4_CLEAR   0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC5         5:5             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC5_NONE    0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC5_CLEAR   0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC6         6:6             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC6_NONE    0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC6_CLEAR   0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC7         7:7             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC7_NONE    0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_1_AN1_TIMEOUT_VC7_CLEAR   0x00000001      /* RW--V */

#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1            0x000012ac      /* RW-4R */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC0 0:0        /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC0_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC0_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC1 1:1        /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC1_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC1_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC2 2:2        /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC2_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC2_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC3 3:3        /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC3_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC3_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC4 4:4        /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC4_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC4_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC5 5:5        /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC5_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC5_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC6 6:6        /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC6_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC6_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC7 7:7        /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC7_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_NON_FATAL_REPORT_EN_1_AN1_TIMEOUT_VC7_ENABLE 0x00000001 /* RW--V */

#define NV_NVLTLC_TX_LNK_ERR_FIRST_1                          0x000012bc      /* RW-4R */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC0          0:0             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC0_NONE     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC0_CLEAR    0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC1          1:1             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC1_NONE     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC1_CLEAR    0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC2          2:2             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC2_NONE     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC2_CLEAR    0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC3          3:3             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC3_NONE     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC3_CLEAR    0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC4          4:4             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC4_NONE     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC4_CLEAR    0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC5          5:5             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC5_NONE     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC5_CLEAR    0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC6          6:6             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC6_NONE     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC6_CLEAR    0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC7          7:7             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC7_NONE     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_1_AN1_TIMEOUT_VC7_CLEAR    0x00000001      /* RW--V */

#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1                  0x000012b8      /* RW-4R */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC0  0:0             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC0_INIT 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC0_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC1  1:1             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC1_INIT 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC1_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC2  2:2             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC2_INIT 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC2_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC3  3:3             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC3_INIT 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC3_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC4  4:4             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC4_INIT 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC4_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC5  5:5             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC5_INIT 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC5_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC6  6:6             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC6_INIT 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC6_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC7  7:7             /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC7_INIT 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_1_AN1_TIMEOUT_VC7_INSERT 0x00000001 /* RW--V */

#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0                0x00000288      /* RW-4R */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_PARITY_ERR 0:0          /* RWEVF */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_PARITY_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_PARITY_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_HDR_ECC_DBE_ERR 8:8     /* RWEVF */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_HDR_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_HDR_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_DAT_ECC_DBE_ERR 9:9     /* RWEVF */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_DAT_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_DAT_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_ECC_LIMIT_ERR 10:10     /* RWEVF */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_TXPOISONDET    23:23           /* RWEVF */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_TXPOISONDET_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_TXPOISONDET_ENABLE 0x00000001  /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_TXRSPSTATUS_HW_ERR 24:24       /* RWEVF */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_TXRSPSTATUS_HW_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_TXRSPSTATUS_HW_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_TXRSPSTATUS_UR_ERR 25:25       /* RWEVF */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_TXRSPSTATUS_UR_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_TXRSPSTATUS_UR_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_TXRSPSTATUS_PRIV_ERR 26:26     /* RWEVF */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_TXRSPSTATUS_PRIV_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_SYS_ERR_FATAL_REPORT_EN_0_TXRSPSTATUS_PRIV_ERR_ENABLE 0x00000001 /* RW--V */

#define NV_NVLTLC_TX_SYS_ERR_FIRST_0                          0x0000029c      /* RW-4R */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_NCISOC_PARITY_ERR        0:0             /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_NCISOC_PARITY_ERR_NONE   0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_NCISOC_PARITY_ERR_CLEAR  0x00000001      /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_NCISOC_HDR_ECC_DBE_ERR   8:8             /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_NCISOC_HDR_ECC_DBE_ERR_NONE 0x00000000   /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_NCISOC_HDR_ECC_DBE_ERR_CLEAR 0x00000001  /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_NCISOC_DAT_ECC_DBE_ERR   9:9             /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_NCISOC_DAT_ECC_DBE_ERR_NONE 0x00000000   /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_NCISOC_DAT_ECC_DBE_ERR_CLEAR 0x00000001  /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_NCISOC_ECC_LIMIT_ERR     10:10           /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_NCISOC_ECC_LIMIT_ERR_NONE 0x00000000     /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_NCISOC_ECC_LIMIT_ERR_CLEAR 0x00000001    /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_TXPOISONDET              23:23           /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_TXPOISONDET_NONE         0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_TXPOISONDET_CLEAR        0x00000001      /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_TXRSPSTATUS_HW_ERR       24:24           /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_TXRSPSTATUS_HW_ERR_NONE  0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_TXRSPSTATUS_HW_ERR_CLEAR 0x00000001      /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_TXRSPSTATUS_UR_ERR       25:25           /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_TXRSPSTATUS_UR_ERR_NONE  0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_TXRSPSTATUS_UR_ERR_CLEAR 0x00000001      /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_TXRSPSTATUS_PRIV_ERR     26:26           /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_TXRSPSTATUS_PRIV_ERR_NONE 0x00000000     /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_FIRST_0_TXRSPSTATUS_PRIV_ERR_CLEAR 0x00000001    /* RW--V */

#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0                  0x00000298      /* RW-4R */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_NCISOC_PARITY_ERR 0:0            /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_NCISOC_PARITY_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_NCISOC_PARITY_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_NCISOC_HDR_ECC_DBE_ERR 8:8       /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_NCISOC_HDR_ECC_DBE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_NCISOC_HDR_ECC_DBE_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_NCISOC_DAT_ECC_DBE_ERR 9:9       /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_NCISOC_DAT_ECC_DBE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_NCISOC_DAT_ECC_DBE_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_NCISOC_ECC_LIMIT_ERR 10:10       /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_NCISOC_ECC_LIMIT_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_NCISOC_ECC_LIMIT_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_TXPOISONDET      23:23           /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_TXPOISONDET_INIT 0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_TXPOISONDET_INSERT 0x00000001    /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_TXRSPSTATUS_HW_ERR 24:24         /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_TXRSPSTATUS_HW_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_TXRSPSTATUS_HW_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_TXRSPSTATUS_UR_ERR 25:25         /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_TXRSPSTATUS_UR_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_TXRSPSTATUS_UR_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_TXRSPSTATUS_PRIV_ERR 26:26       /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_TXRSPSTATUS_PRIV_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_REPORT_INJECT_0_TXRSPSTATUS_PRIV_ERR_INSERT 0x00000001 /* RW--V */

#define NV_NVLTLC_TX_SYS_ERR_STATUS_0                         0x00000280      /* RW-4R */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_NCISOC_PARITY_ERR       0:0             /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_NCISOC_PARITY_ERR_NONE  0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_NCISOC_PARITY_ERR_CLEAR 0x00000001      /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_NCISOC_HDR_ECC_DBE_ERR  8:8             /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_NCISOC_HDR_ECC_DBE_ERR_NONE 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_NCISOC_HDR_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_NCISOC_DAT_ECC_DBE_ERR  9:9             /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_NCISOC_DAT_ECC_DBE_ERR_NONE 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_NCISOC_DAT_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_NCISOC_ECC_LIMIT_ERR    10:10           /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_NCISOC_ECC_LIMIT_ERR_NONE 0x00000000    /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_NCISOC_ECC_LIMIT_ERR_CLEAR 0x00000001   /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_TXPOISONDET             23:23           /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_TXPOISONDET_NONE        0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_TXPOISONDET_CLEAR       0x00000001      /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_TXRSPSTATUS_HW_ERR      24:24           /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_TXRSPSTATUS_HW_ERR_NONE 0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_TXRSPSTATUS_HW_ERR_CLEAR 0x00000001     /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_TXRSPSTATUS_UR_ERR      25:25           /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_TXRSPSTATUS_UR_ERR_NONE 0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_TXRSPSTATUS_UR_ERR_CLEAR 0x00000001     /* RW--V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_TXRSPSTATUS_PRIV_ERR    26:26           /* RWDVF */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_TXRSPSTATUS_PRIV_ERR_NONE 0x00000000    /* RWD-V */
#define NV_NVLTLC_TX_SYS_ERR_STATUS_0_TXRSPSTATUS_PRIV_ERR_CLEAR 0x00000001   /* RW--V */

#define NV_NVLTLC_RX_SYS_ERR_STATUS_0                         0x00000a80      /* RW-4R */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_NCISOC_PARITY_ERR       0:0             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_NCISOC_PARITY_ERR_NONE  0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_NCISOC_PARITY_ERR_CLEAR 0x00000001      /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_HDR_RAM_ECC_DBE_ERR     1:1             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_HDR_RAM_ECC_DBE_ERR_NONE 0x00000000     /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_HDR_RAM_ECC_DBE_ERR_CLEAR 0x00000001    /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_HDR_RAM_ECC_LIMIT_ERR   2:2             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_HDR_RAM_ECC_LIMIT_ERR_NONE 0x00000000   /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_HDR_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001  /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_DAT0_RAM_ECC_DBE_ERR    3:3             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_DAT0_RAM_ECC_DBE_ERR_NONE 0x00000000    /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_DAT0_RAM_ECC_DBE_ERR_CLEAR 0x00000001   /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_DAT0_RAM_ECC_LIMIT_ERR  4:4             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_DAT0_RAM_ECC_LIMIT_ERR_NONE 0x00000000  /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_DAT0_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_DAT1_RAM_ECC_DBE_ERR    5:5             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_DAT1_RAM_ECC_DBE_ERR_NONE 0x00000000    /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_DAT1_RAM_ECC_DBE_ERR_CLEAR 0x00000001   /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_DAT1_RAM_ECC_LIMIT_ERR  6:6             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_DAT1_RAM_ECC_LIMIT_ERR_NONE 0x00000000  /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_STATUS_0_DAT1_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001 /* RW--V */

#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0                0x00000a88      /* RW-4R */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_PARITY_ERR 0:0          /* RWEVF */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_PARITY_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_NCISOC_PARITY_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_HDR_RAM_ECC_DBE_ERR 1:1        /* RWEVF */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_HDR_RAM_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_HDR_RAM_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_HDR_RAM_ECC_LIMIT_ERR 2:2      /* RWEVF */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_HDR_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_HDR_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_DAT0_RAM_ECC_DBE_ERR 3:3       /* RWEVF */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_DAT0_RAM_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_DAT0_RAM_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_DAT0_RAM_ECC_LIMIT_ERR 4:4     /* RWEVF */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_DAT0_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_DAT0_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_DAT1_RAM_ECC_DBE_ERR 5:5       /* RWEVF */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_DAT1_RAM_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_DAT1_RAM_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_DAT1_RAM_ECC_LIMIT_ERR 6:6     /* RWEVF */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_DAT1_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_SYS_ERR_FATAL_REPORT_EN_0_DAT1_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */

#define NV_NVLTLC_RX_SYS_ERR_FIRST_0                          0x00000a9c      /* RW-4R */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_NCISOC_PARITY_ERR        0:0             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_NCISOC_PARITY_ERR_NONE   0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_NCISOC_PARITY_ERR_CLEAR  0x00000001      /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_HDR_RAM_ECC_DBE_ERR      1:1             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_HDR_RAM_ECC_DBE_ERR_NONE 0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_HDR_RAM_ECC_DBE_ERR_CLEAR 0x00000001     /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_HDR_RAM_ECC_LIMIT_ERR    2:2             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_HDR_RAM_ECC_LIMIT_ERR_NONE 0x00000000    /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_HDR_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001   /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_DAT0_RAM_ECC_DBE_ERR     3:3             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_DAT0_RAM_ECC_DBE_ERR_NONE 0x00000000     /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_DAT0_RAM_ECC_DBE_ERR_CLEAR 0x00000001    /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_DAT0_RAM_ECC_LIMIT_ERR   4:4             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_DAT0_RAM_ECC_LIMIT_ERR_NONE 0x00000000   /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_DAT0_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001  /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_DAT1_RAM_ECC_DBE_ERR     5:5             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_DAT1_RAM_ECC_DBE_ERR_NONE 0x00000000     /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_DAT1_RAM_ECC_DBE_ERR_CLEAR 0x00000001    /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_DAT1_RAM_ECC_LIMIT_ERR   6:6             /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_DAT1_RAM_ECC_LIMIT_ERR_NONE 0x00000000   /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_FIRST_0_DAT1_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001  /* RW--V */

#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0                  0x00000a98      /* RW-4R */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_NCISOC_PARITY_ERR 0:0            /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_NCISOC_PARITY_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_NCISOC_PARITY_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_HDR_RAM_ECC_DBE_ERR 1:1          /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_HDR_RAM_ECC_DBE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_HDR_RAM_ECC_DBE_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_HDR_RAM_ECC_LIMIT_ERR 2:2        /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_HDR_RAM_ECC_LIMIT_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_HDR_RAM_ECC_LIMIT_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_DAT0_RAM_ECC_DBE_ERR 3:3         /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_DAT0_RAM_ECC_DBE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_DAT0_RAM_ECC_DBE_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_DAT0_RAM_ECC_LIMIT_ERR 4:4       /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_DAT0_RAM_ECC_LIMIT_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_DAT0_RAM_ECC_LIMIT_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_DAT1_RAM_ECC_DBE_ERR 5:5         /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_DAT1_RAM_ECC_DBE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_DAT1_RAM_ECC_DBE_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_DAT1_RAM_ECC_LIMIT_ERR 6:6       /* RWDVF */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_DAT1_RAM_ECC_LIMIT_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_SYS_ERR_REPORT_INJECT_0_DAT1_RAM_ECC_LIMIT_ERR_INSERT 0x00000001 /* RW--V */

#define NV_NVLTLC_TX_LNK_ERR_STATUS_0                         0x00001280      /* RW-4R */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_TXDLCREDITPARITYERR     17:17           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_TXDLCREDITPARITYERR_NONE 0x00000000     /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_TXDLCREDITPARITYERR_CLEAR 0x00000001    /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_CREQ_RAM_HDR_ECC_DBE_ERR 18:18          /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_CREQ_RAM_HDR_ECC_DBE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_CREQ_RAM_HDR_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_CREQ_RAM_DAT_ECC_DBE_ERR 19:19          /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_CREQ_RAM_DAT_ECC_DBE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_CREQ_RAM_DAT_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_CREQ_RAM_ECC_LIMIT_ERR  20:20           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_CREQ_RAM_ECC_LIMIT_ERR_NONE 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_CREQ_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP_RAM_HDR_ECC_DBE_ERR 21:21           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP_RAM_HDR_ECC_DBE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP_RAM_HDR_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP_RAM_DAT_ECC_DBE_ERR 22:22           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP_RAM_DAT_ECC_DBE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP_RAM_DAT_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP_RAM_ECC_LIMIT_ERR   23:23           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP_RAM_ECC_LIMIT_ERR_NONE 0x00000000   /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001  /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_COM_RAM_HDR_ECC_DBE_ERR 24:24           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_COM_RAM_HDR_ECC_DBE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_COM_RAM_HDR_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_COM_RAM_DAT_ECC_DBE_ERR 25:25           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_COM_RAM_DAT_ECC_DBE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_COM_RAM_DAT_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_COM_RAM_ECC_LIMIT_ERR   26:26           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_COM_RAM_ECC_LIMIT_ERR_NONE 0x00000000   /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_COM_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001  /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP1_RAM_HDR_ECC_DBE_ERR 27:27          /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP1_RAM_HDR_ECC_DBE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP1_RAM_HDR_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP1_RAM_DAT_ECC_DBE_ERR 28:28          /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP1_RAM_DAT_ECC_DBE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP1_RAM_DAT_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP1_RAM_ECC_LIMIT_ERR  29:29           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP1_RAM_ECC_LIMIT_ERR_NONE 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_STATUS_0_RSP1_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001 /* RW--V */

#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0                0x00001288      /* RW-4R */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_TXDLCREDITPARITYERR 17:17      /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_TXDLCREDITPARITYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_TXDLCREDITPARITYERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_CREQ_RAM_HDR_ECC_DBE_ERR 18:18 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_CREQ_RAM_HDR_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_CREQ_RAM_HDR_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_CREQ_RAM_DAT_ECC_DBE_ERR 19:19 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_CREQ_RAM_DAT_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_CREQ_RAM_DAT_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_CREQ_RAM_ECC_LIMIT_ERR 20:20   /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_CREQ_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_CREQ_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP_RAM_HDR_ECC_DBE_ERR 21:21  /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP_RAM_HDR_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP_RAM_HDR_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP_RAM_DAT_ECC_DBE_ERR 22:22  /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP_RAM_DAT_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP_RAM_DAT_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP_RAM_ECC_LIMIT_ERR 23:23    /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_COM_RAM_HDR_ECC_DBE_ERR 24:24  /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_COM_RAM_HDR_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_COM_RAM_HDR_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_COM_RAM_DAT_ECC_DBE_ERR 25:25  /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_COM_RAM_DAT_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_COM_RAM_DAT_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_COM_RAM_ECC_LIMIT_ERR 26:26    /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_COM_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_COM_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP1_RAM_HDR_ECC_DBE_ERR 27:27 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP1_RAM_HDR_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP1_RAM_HDR_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP1_RAM_DAT_ECC_DBE_ERR 28:28 /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP1_RAM_DAT_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP1_RAM_DAT_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP1_RAM_ECC_LIMIT_ERR 29:29   /* RWEVF */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP1_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_TX_LNK_ERR_FATAL_REPORT_EN_0_RSP1_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */

#define NV_NVLTLC_TX_LNK_ERR_FIRST_0                          0x0000129c      /* RW-4R */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_TXDLCREDITPARITYERR      17:17           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_TXDLCREDITPARITYERR_NONE 0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_TXDLCREDITPARITYERR_CLEAR 0x00000001     /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_CREQ_RAM_HDR_ECC_DBE_ERR 18:18           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_CREQ_RAM_HDR_ECC_DBE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_CREQ_RAM_HDR_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_CREQ_RAM_DAT_ECC_DBE_ERR 19:19           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_CREQ_RAM_DAT_ECC_DBE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_CREQ_RAM_DAT_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_CREQ_RAM_ECC_LIMIT_ERR   20:20           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_CREQ_RAM_ECC_LIMIT_ERR_NONE 0x00000000   /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_CREQ_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001  /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP_RAM_HDR_ECC_DBE_ERR  21:21           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP_RAM_HDR_ECC_DBE_ERR_NONE 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP_RAM_HDR_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP_RAM_DAT_ECC_DBE_ERR  22:22           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP_RAM_DAT_ECC_DBE_ERR_NONE 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP_RAM_DAT_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP_RAM_ECC_LIMIT_ERR    23:23           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP_RAM_ECC_LIMIT_ERR_NONE 0x00000000    /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001   /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_COM_RAM_HDR_ECC_DBE_ERR  24:24           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_COM_RAM_HDR_ECC_DBE_ERR_NONE 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_COM_RAM_HDR_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_COM_RAM_DAT_ECC_DBE_ERR  25:25           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_COM_RAM_DAT_ECC_DBE_ERR_NONE 0x00000000  /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_COM_RAM_DAT_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_COM_RAM_ECC_LIMIT_ERR    26:26           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_COM_RAM_ECC_LIMIT_ERR_NONE 0x00000000    /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_COM_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001   /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP1_RAM_HDR_ECC_DBE_ERR 27:27           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP1_RAM_HDR_ECC_DBE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP1_RAM_HDR_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP1_RAM_DAT_ECC_DBE_ERR 28:28           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP1_RAM_DAT_ECC_DBE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP1_RAM_DAT_ECC_DBE_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP1_RAM_ECC_LIMIT_ERR   29:29           /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP1_RAM_ECC_LIMIT_ERR_NONE 0x00000000   /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_FIRST_0_RSP1_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001  /* RW--V */

#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0                  0x00001298      /* RW-4R */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_TXDLCREDITPARITYERR 17:17        /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_TXDLCREDITPARITYERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_TXDLCREDITPARITYERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_CREQ_RAM_HDR_ECC_DBE_ERR 18:18   /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_CREQ_RAM_HDR_ECC_DBE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_CREQ_RAM_HDR_ECC_DBE_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_CREQ_RAM_DAT_ECC_DBE_ERR 19:19   /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_CREQ_RAM_DAT_ECC_DBE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_CREQ_RAM_DAT_ECC_DBE_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_CREQ_RAM_ECC_LIMIT_ERR 20:20     /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_CREQ_RAM_ECC_LIMIT_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_CREQ_RAM_ECC_LIMIT_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP_RAM_HDR_ECC_DBE_ERR 21:21    /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP_RAM_HDR_ECC_DBE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP_RAM_HDR_ECC_DBE_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP_RAM_DAT_ECC_DBE_ERR 22:22    /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP_RAM_DAT_ECC_DBE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP_RAM_DAT_ECC_DBE_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP_RAM_ECC_LIMIT_ERR 23:23      /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP_RAM_ECC_LIMIT_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP_RAM_ECC_LIMIT_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_COM_RAM_HDR_ECC_DBE_ERR 24:24    /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_COM_RAM_HDR_ECC_DBE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_COM_RAM_HDR_ECC_DBE_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_COM_RAM_DAT_ECC_DBE_ERR 25:25    /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_COM_RAM_DAT_ECC_DBE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_COM_RAM_DAT_ECC_DBE_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_COM_RAM_ECC_LIMIT_ERR 26:26      /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_COM_RAM_ECC_LIMIT_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_COM_RAM_ECC_LIMIT_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP1_RAM_HDR_ECC_DBE_ERR 27:27   /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP1_RAM_HDR_ECC_DBE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP1_RAM_HDR_ECC_DBE_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP1_RAM_DAT_ECC_DBE_ERR 28:28   /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP1_RAM_DAT_ECC_DBE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP1_RAM_DAT_ECC_DBE_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP1_RAM_ECC_LIMIT_ERR 29:29     /* RWDVF */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP1_RAM_ECC_LIMIT_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_ERR_REPORT_INJECT_0_RSP1_RAM_ECC_LIMIT_ERR_INSERT 0x00000001 /* RW--V */

#define NV_NVLTLC_RX_LNK_ERR_STATUS_0                         0x00001a80      /* RW-4R */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXDLHDRPARITYERR        0:0             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXDLHDRPARITYERR_NONE   0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXDLHDRPARITYERR_CLEAR  0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXDLDATAPARITYERR       1:1             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXDLDATAPARITYERR_NONE  0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXDLDATAPARITYERR_CLEAR 0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXDLCTRLPARITYERR       2:2             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXDLCTRLPARITYERR_NONE  0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXDLCTRLPARITYERR_CLEAR 0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXINVALIDAEERR          3:3             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXINVALIDAEERR_NONE     0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXINVALIDAEERR_CLEAR    0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXINVALIDBEERR          4:4             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXINVALIDBEERR_NONE     0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXINVALIDBEERR_CLEAR    0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXINVALIDADDRALIGNERR   5:5             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXINVALIDADDRALIGNERR_NONE 0x00000000   /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXINVALIDADDRALIGNERR_CLEAR 0x00000001  /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXPKTLENERR             6:6             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXPKTLENERR_NONE        0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXPKTLENERR_CLEAR       0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVCMDENCERR            7:7             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVCMDENCERR_NONE       0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVCMDENCERR_CLEAR      0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVDATLENENCERR         8:8             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVDATLENENCERR_NONE    0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVDATLENENCERR_CLEAR   0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVPKTSTATUSERR         9:9             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVPKTSTATUSERR_NONE    0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVPKTSTATUSERR_CLEAR   0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVCACHEATTRPROBEREQERR 10:10           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVCACHEATTRPROBEREQERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVCACHEATTRPROBEREQERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVCACHEATTRPROBERSPERR 11:11           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVCACHEATTRPROBERSPERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RSVCACHEATTRPROBERSPERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_DATLENGTRMWREQMAXERR    12:12           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_DATLENGTRMWREQMAXERR_NONE 0x00000000    /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_DATLENGTRMWREQMAXERR_CLEAR 0x00000001   /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_DATLENLTATRRSPMINERR    13:13           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_DATLENLTATRRSPMINERR_NONE 0x00000000    /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_DATLENLTATRRSPMINERR_CLEAR 0x00000001   /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_INVALIDCACHEATTRPOERR   14:14           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_INVALIDCACHEATTRPOERR_NONE 0x00000000   /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_INVALIDCACHEATTRPOERR_CLEAR 0x00000001  /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_INVALIDCRERR            15:15           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_INVALIDCRERR_NONE       0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_INVALIDCRERR_CLEAR      0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXRSPSTATUS_HW_ERR      16:16           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXRSPSTATUS_HW_ERR_NONE 0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXRSPSTATUS_HW_ERR_CLEAR 0x00000001     /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXRSPSTATUS_UR_ERR      17:17           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXRSPSTATUS_UR_ERR_NONE 0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXRSPSTATUS_UR_ERR_CLEAR 0x00000001     /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXRSPSTATUS_PRIV_ERR    18:18           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXRSPSTATUS_PRIV_ERR_NONE 0x00000000    /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_RXRSPSTATUS_PRIV_ERR_CLEAR 0x00000001   /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_INVALID_COLLAPSED_RESPONSE_ERR 19:19    /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_INVALID_COLLAPSED_RESPONSE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_0_INVALID_COLLAPSED_RESPONSE_ERR_CLEAR 0x00000001 /* RW--V */

#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0                0x00001a88      /* RW-4R */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXDLHDRPARITYERR 0:0           /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXDLHDRPARITYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXDLHDRPARITYERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXDLDATAPARITYERR 1:1          /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXDLDATAPARITYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXDLDATAPARITYERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXDLCTRLPARITYERR 2:2          /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXDLCTRLPARITYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXDLCTRLPARITYERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXINVALIDAEERR 3:3             /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXINVALIDAEERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXINVALIDAEERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXINVALIDBEERR 4:4             /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXINVALIDBEERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXINVALIDBEERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXINVALIDADDRALIGNERR 5:5      /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXINVALIDADDRALIGNERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXINVALIDADDRALIGNERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXPKTLENERR    6:6             /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXPKTLENERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXPKTLENERR_ENABLE 0x00000001  /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVCMDENCERR   7:7             /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVCMDENCERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVCMDENCERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVDATLENENCERR 8:8            /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVDATLENENCERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVDATLENENCERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVPKTSTATUSERR 9:9            /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVPKTSTATUSERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVPKTSTATUSERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVCACHEATTRPROBEREQERR 10:10  /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVCACHEATTRPROBEREQERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVCACHEATTRPROBEREQERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVCACHEATTRPROBERSPERR 11:11  /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVCACHEATTRPROBERSPERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RSVCACHEATTRPROBERSPERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_DATLENGTRMWREQMAXERR 12:12     /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_DATLENGTRMWREQMAXERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_DATLENGTRMWREQMAXERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_DATLENLTATRRSPMINERR 13:13     /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_DATLENLTATRRSPMINERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_DATLENLTATRRSPMINERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_INVALIDCACHEATTRPOERR 14:14    /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_INVALIDCACHEATTRPOERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_INVALIDCACHEATTRPOERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_INVALIDCRERR   15:15           /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_INVALIDCRERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_INVALIDCRERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXRSPSTATUS_HW_ERR 16:16       /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXRSPSTATUS_HW_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXRSPSTATUS_HW_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXRSPSTATUS_UR_ERR 17:17       /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXRSPSTATUS_UR_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXRSPSTATUS_UR_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXRSPSTATUS_PRIV_ERR 18:18     /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXRSPSTATUS_PRIV_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_RXRSPSTATUS_PRIV_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_INVALID_COLLAPSED_RESPONSE_ERR 19:19 /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_INVALID_COLLAPSED_RESPONSE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_0_INVALID_COLLAPSED_RESPONSE_ERR_ENABLE 0x00000001 /* RW--V */

#define NV_NVLTLC_RX_LNK_ERR_FIRST_0                          0x00001a9c      /* RW-4R */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXDLHDRPARITYERR         0:0             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXDLHDRPARITYERR_NONE    0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXDLHDRPARITYERR_CLEAR   0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXDLDATAPARITYERR        1:1             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXDLDATAPARITYERR_NONE   0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXDLDATAPARITYERR_CLEAR  0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXDLCTRLPARITYERR        2:2             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXDLCTRLPARITYERR_NONE   0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXDLCTRLPARITYERR_CLEAR  0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXINVALIDAEERR           3:3             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXINVALIDAEERR_NONE      0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXINVALIDAEERR_CLEAR     0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXINVALIDBEERR           4:4             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXINVALIDBEERR_NONE      0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXINVALIDBEERR_CLEAR     0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXINVALIDADDRALIGNERR    5:5             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXINVALIDADDRALIGNERR_NONE 0x00000000    /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXINVALIDADDRALIGNERR_CLEAR 0x00000001   /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXPKTLENERR              6:6             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXPKTLENERR_NONE         0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXPKTLENERR_CLEAR        0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVCMDENCERR             7:7             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVCMDENCERR_NONE        0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVCMDENCERR_CLEAR       0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVDATLENENCERR          8:8             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVDATLENENCERR_NONE     0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVDATLENENCERR_CLEAR    0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVPKTSTATUSERR          9:9             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVPKTSTATUSERR_NONE     0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVPKTSTATUSERR_CLEAR    0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVCACHEATTRPROBEREQERR  10:10           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVCACHEATTRPROBEREQERR_NONE 0x00000000  /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVCACHEATTRPROBEREQERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVCACHEATTRPROBERSPERR  11:11           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVCACHEATTRPROBERSPERR_NONE 0x00000000  /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RSVCACHEATTRPROBERSPERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_DATLENGTRMWREQMAXERR     12:12           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_DATLENGTRMWREQMAXERR_NONE 0x00000000     /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_DATLENGTRMWREQMAXERR_CLEAR 0x00000001    /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_DATLENLTATRRSPMINERR     13:13           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_DATLENLTATRRSPMINERR_NONE 0x00000000     /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_DATLENLTATRRSPMINERR_CLEAR 0x00000001    /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_INVALIDCACHEATTRPOERR    14:14           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_INVALIDCACHEATTRPOERR_NONE 0x00000000    /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_INVALIDCACHEATTRPOERR_CLEAR 0x00000001   /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_INVALIDCRERR             15:15           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_INVALIDCRERR_NONE        0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_INVALIDCRERR_CLEAR       0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXRSPSTATUS_HW_ERR       16:16           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXRSPSTATUS_HW_ERR_NONE  0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXRSPSTATUS_HW_ERR_CLEAR 0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXRSPSTATUS_UR_ERR       17:17           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXRSPSTATUS_UR_ERR_NONE  0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXRSPSTATUS_UR_ERR_CLEAR 0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXRSPSTATUS_PRIV_ERR     18:18           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXRSPSTATUS_PRIV_ERR_NONE 0x00000000     /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_RXRSPSTATUS_PRIV_ERR_CLEAR 0x00000001    /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_INVALID_COLLAPSED_RESPONSE_ERR 19:19     /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_INVALID_COLLAPSED_RESPONSE_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_0_INVALID_COLLAPSED_RESPONSE_ERR_CLEAR 0x00000001 /* RW--V */

#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0                  0x00001a98      /* RW-4R */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXDLHDRPARITYERR 0:0             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXDLHDRPARITYERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXDLHDRPARITYERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXDLDATAPARITYERR 1:1            /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXDLDATAPARITYERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXDLDATAPARITYERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXDLCTRLPARITYERR 2:2            /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXDLCTRLPARITYERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXDLCTRLPARITYERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXINVALIDAEERR   3:3             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXINVALIDAEERR_INIT 0x00000000   /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXINVALIDAEERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXINVALIDBEERR   4:4             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXINVALIDBEERR_INIT 0x00000000   /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXINVALIDBEERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXINVALIDADDRALIGNERR 5:5        /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXINVALIDADDRALIGNERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXINVALIDADDRALIGNERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXPKTLENERR      6:6             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXPKTLENERR_INIT 0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXPKTLENERR_INSERT 0x00000001    /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVCMDENCERR     7:7             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVCMDENCERR_INIT 0x00000000     /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVCMDENCERR_INSERT 0x00000001   /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVDATLENENCERR  8:8             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVDATLENENCERR_INIT 0x00000000  /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVDATLENENCERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVPKTSTATUSERR  9:9             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVPKTSTATUSERR_INIT 0x00000000  /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVPKTSTATUSERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVCACHEATTRPROBEREQERR 10:10    /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVCACHEATTRPROBEREQERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVCACHEATTRPROBEREQERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVCACHEATTRPROBERSPERR 11:11    /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVCACHEATTRPROBERSPERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RSVCACHEATTRPROBERSPERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_DATLENGTRMWREQMAXERR 12:12       /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_DATLENGTRMWREQMAXERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_DATLENGTRMWREQMAXERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_DATLENLTATRRSPMINERR 13:13       /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_DATLENLTATRRSPMINERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_DATLENLTATRRSPMINERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_INVALIDCACHEATTRPOERR 14:14      /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_INVALIDCACHEATTRPOERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_INVALIDCACHEATTRPOERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_INVALIDCRERR     15:15           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_INVALIDCRERR_INIT 0x00000000     /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_INVALIDCRERR_INSERT 0x00000001   /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXRSPSTATUS_HW_ERR 16:16         /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXRSPSTATUS_HW_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXRSPSTATUS_HW_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXRSPSTATUS_UR_ERR 17:17         /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXRSPSTATUS_UR_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXRSPSTATUS_UR_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXRSPSTATUS_PRIV_ERR 18:18       /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXRSPSTATUS_PRIV_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_RXRSPSTATUS_PRIV_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_INVALID_COLLAPSED_RESPONSE_ERR 19:19 /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_INVALID_COLLAPSED_RESPONSE_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_0_INVALID_COLLAPSED_RESPONSE_ERR_INSERT 0x00000001 /* RW--V */

#define NV_NVLTLC_RX_LNK_ERR_STATUS_1                         0x00001aa0      /* RW-4R */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_RXHDROVFERR             7:0             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_RXHDROVFERR_NONE        0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_RXHDROVFERR_CLEAR       0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_RXDATAOVFERR            15:8            /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_RXDATAOVFERR_NONE       0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_RXDATAOVFERR_CLEAR      0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_STOMPDETERR             16:16           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_STOMPDETERR_NONE        0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_STOMPDETERR_CLEAR       0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_RXPOISONERR             17:17           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_RXPOISONERR_NONE        0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_RXPOISONERR_CLEAR       0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_AN1_HEARTBEAT_TIMEOUT_ERR 18:18         /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_AN1_HEARTBEAT_TIMEOUT_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_STATUS_1_AN1_HEARTBEAT_TIMEOUT_ERR_CLEAR 0x00000001 /* RW--V */

#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1                0x00001aa8      /* RW-4R */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_RXHDROVFERR    7:0             /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_RXHDROVFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_RXHDROVFERR_ENABLE 0x00000001  /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_RXDATAOVFERR   15:8            /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_RXDATAOVFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_RXDATAOVFERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_STOMPDETERR    16:16           /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_STOMPDETERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_STOMPDETERR_ENABLE 0x00000001  /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_RXPOISONERR    17:17           /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_RXPOISONERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_RXPOISONERR_ENABLE 0x00000001  /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_AN1_HEARTBEAT_TIMEOUT_ERR 18:18 /* RWEVF */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_AN1_HEARTBEAT_TIMEOUT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLTLC_RX_LNK_ERR_FATAL_REPORT_EN_1_AN1_HEARTBEAT_TIMEOUT_ERR_ENABLE 0x00000001 /* RW--V */

#define NV_NVLTLC_RX_LNK_ERR_FIRST_1                          0x00001abc      /* RW-4R */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_RXHDROVFERR              7:0             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_RXHDROVFERR_NONE         0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_RXHDROVFERR_CLEAR        0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_RXDATAOVFERR             15:8            /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_RXDATAOVFERR_NONE        0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_RXDATAOVFERR_CLEAR       0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_STOMPDETERR              16:16           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_STOMPDETERR_NONE         0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_STOMPDETERR_CLEAR        0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_RXPOISONERR              17:17           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_RXPOISONERR_NONE         0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_RXPOISONERR_CLEAR        0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_AN1_HEARTBEAT_TIMEOUT_ERR 18:18          /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_AN1_HEARTBEAT_TIMEOUT_ERR_NONE 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_FIRST_1_AN1_HEARTBEAT_TIMEOUT_ERR_CLEAR 0x00000001 /* RW--V */

#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1                  0x00001ab8      /* RW-4R */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_RXHDROVFERR      7:0             /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_RXHDROVFERR_INIT 0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_RXHDROVFERR_INSERT 0x00000001    /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_RXDATAOVFERR     15:8            /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_RXDATAOVFERR_INIT 0x00000000     /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_RXDATAOVFERR_INSERT 0x00000001   /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_STOMPDETERR      16:16           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_STOMPDETERR_INIT 0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_STOMPDETERR_INSERT 0x00000001    /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_RXPOISONERR      17:17           /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_RXPOISONERR_INIT 0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_RXPOISONERR_INSERT 0x00000001    /* RW--V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_AN1_HEARTBEAT_TIMEOUT_ERR 18:18  /* RWDVF */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_AN1_HEARTBEAT_TIMEOUT_ERR_INIT 0x00000000 /* RWD-V */
#define NV_NVLTLC_RX_LNK_ERR_REPORT_INJECT_1_AN1_HEARTBEAT_TIMEOUT_ERR_INSERT 0x00000001 /* RW--V */

#define NV_NVLTLC_TX_LNK_PWRM_IC_LIMIT                        0x00001418      /* RW-4R */
#define NV_NVLTLC_TX_LNK_PWRM_IC_LIMIT_LIMIT                  31:0            /* RWEVF */
#define NV_NVLTLC_TX_LNK_PWRM_IC_LIMIT_LIMIT_INIT             0x00000000      /* RWE-V */

#define NV_NVLTLC_RX_LNK_PWRM_IC_LIMIT                        0x00001c18      /* RW-4R */
#define NV_NVLTLC_RX_LNK_PWRM_IC_LIMIT_LIMIT                  31:0            /* RWEVF */
#define NV_NVLTLC_RX_LNK_PWRM_IC_LIMIT_LIMIT_INIT             0x00000000      /* RWE-V */

#define NV_NVLTLC_TX_LNK_PWRM_IC_INC                          0x00001408      /* RW-4R */
#define NV_NVLTLC_TX_LNK_PWRM_IC_INC_FBINC                    15:0            /* RWEVF */
#define NV_NVLTLC_TX_LNK_PWRM_IC_INC_FBINC_INIT               0x00000000      /* RWE-V */
#define NV_NVLTLC_TX_LNK_PWRM_IC_INC_LPINC                    31:16           /* RWEVF */
#define NV_NVLTLC_TX_LNK_PWRM_IC_INC_LPINC_INIT               0x00000000      /* RWE-V */

#define NV_NVLTLC_RX_LNK_PWRM_IC_INC                          0x00001c08      /* RW-4R */
#define NV_NVLTLC_RX_LNK_PWRM_IC_INC_FBINC                    15:0            /* RWEVF */
#define NV_NVLTLC_RX_LNK_PWRM_IC_INC_FBINC_INIT               0x00000000      /* RWE-V */
#define NV_NVLTLC_RX_LNK_PWRM_IC_INC_LPINC                    31:16           /* RWEVF */
#define NV_NVLTLC_RX_LNK_PWRM_IC_INC_LPINC_INIT               0x00000000      /* RWE-V */

#define NV_NVLTLC_TX_LNK_PWRM_IC_DEC                          0x0000140c      /* RW-4R */
#define NV_NVLTLC_TX_LNK_PWRM_IC_DEC_FBDEC                    15:0            /* RWEVF */
#define NV_NVLTLC_TX_LNK_PWRM_IC_DEC_FBDEC_INIT               0x00000000      /* RWE-V */
#define NV_NVLTLC_TX_LNK_PWRM_IC_DEC_LPDEC                    31:16           /* RWEVF */
#define NV_NVLTLC_TX_LNK_PWRM_IC_DEC_LPDEC_INIT               0x00000000      /* RWE-V */

#define NV_NVLTLC_RX_LNK_PWRM_IC_DEC                          0x00001c0c      /* RW-4R */
#define NV_NVLTLC_RX_LNK_PWRM_IC_DEC_FBDEC                    15:0            /* RWEVF */
#define NV_NVLTLC_RX_LNK_PWRM_IC_DEC_FBDEC_INIT               0x00000000      /* RWE-V */
#define NV_NVLTLC_RX_LNK_PWRM_IC_DEC_LPDEC                    31:16           /* RWEVF */
#define NV_NVLTLC_RX_LNK_PWRM_IC_DEC_LPDEC_INIT               0x00000000      /* RWE-V */

#define NV_NVLTLC_TX_LNK_PWRM_IC_LP_ENTER_THRESHOLD           0x00001410      /* RW-4R */
#define NV_NVLTLC_TX_LNK_PWRM_IC_LP_ENTER_THRESHOLD_THRESHOLD 31:0            /* RWEVF */
#define NV_NVLTLC_TX_LNK_PWRM_IC_LP_ENTER_THRESHOLD_THRESHOLD_INIT 0x00000000 /* RWE-V */

#define NV_NVLTLC_RX_LNK_PWRM_IC_LP_ENTER_THRESHOLD           0x00001c10      /* RW-4R */
#define NV_NVLTLC_RX_LNK_PWRM_IC_LP_ENTER_THRESHOLD_THRESHOLD 31:0            /* RWEVF */
#define NV_NVLTLC_RX_LNK_PWRM_IC_LP_ENTER_THRESHOLD_THRESHOLD_INIT 0x00000000 /* RWE-V */

#define NV_NVLTLC_TX_LNK_PWRM_IC_LP_EXIT_THRESHOLD            0x00001414      /* RW-4R */
#define NV_NVLTLC_TX_LNK_PWRM_IC_LP_EXIT_THRESHOLD_THRESHOLD  31:0            /* RWEVF */
#define NV_NVLTLC_TX_LNK_PWRM_IC_LP_EXIT_THRESHOLD_THRESHOLD_INIT 0x00000000  /* RWE-V */

#define NV_NVLTLC_RX_LNK_PWRM_IC_LP_EXIT_THRESHOLD            0x00001c14      /* RW-4R */
#define NV_NVLTLC_RX_LNK_PWRM_IC_LP_EXIT_THRESHOLD_THRESHOLD  31:0            /* RWEVF */
#define NV_NVLTLC_RX_LNK_PWRM_IC_LP_EXIT_THRESHOLD_THRESHOLD_INIT 0x00000000  /* RWE-V */

#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL                      0x00001400      /* RW-4R */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_CURRENTSTATE         0:0             /* R-EVF */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_CURRENTSTATE_LP      0x00000001      /* R---V */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_CURRENTSTATE_FB      0x00000000      /* R-E-V */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_REMOTEDESIRED        1:1             /* R-EVF */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_REMOTEDESIRED_LP     0x00000001      /* R---V */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_REMOTEDESIRED_FB     0x00000000      /* R-E-V */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_SOFTWAREDESIRED      2:2             /* RWEVF */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_SOFTWAREDESIRED_LP   0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_SOFTWAREDESIRED_FB   0x00000000      /* RWE-V */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_HARDWAREDISABLE      3:3             /* RWEVF */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_HARDWAREDISABLE_INIT 0x00000000      /* RWE-V */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_HARDWAREDESIRED      4:4             /* R-EVF */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_HARDWAREDESIRED_LP   0x00000001      /* R---V */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_HARDWAREDESIRED_FB   0x00000000      /* R-E-V */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_COUNTSTART           5:5             /* RWEVF */
#define NV_NVLTLC_TX_LNK_PWRM_IC_SW_CTRL_COUNTSTART_INIT      0x00000000      /* RWE-V */

#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL                      0x00001c00      /* RW-4R */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_CURRENTSTATE         0:0             /* R-EVF */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_CURRENTSTATE_LP      0x00000001      /* R---V */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_CURRENTSTATE_FB      0x00000000      /* R-E-V */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_REMOTEDESIRED        1:1             /* R-EVF */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_REMOTEDESIRED_LP     0x00000001      /* R---V */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_REMOTEDESIRED_FB     0x00000000      /* R-E-V */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_SOFTWAREDESIRED      2:2             /* RWEVF */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_SOFTWAREDESIRED_LP   0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_SOFTWAREDESIRED_FB   0x00000000      /* RWE-V */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_HARDWAREDISABLE      3:3             /* RWEVF */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_HARDWAREDISABLE_INIT 0x00000000      /* RWE-V */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_HARDWAREDESIRED      4:4             /* R-EVF */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_HARDWAREDESIRED_LP   0x00000001      /* R---V */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_HARDWAREDESIRED_FB   0x00000000      /* R-E-V */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_COUNTSTART           5:5             /* RWEVF */
#define NV_NVLTLC_RX_LNK_PWRM_IC_SW_CTRL_COUNTSTART_INIT      0x00000000      /* RWE-V */

#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0(i)              (0x00001d0c+(i)*0x54) /* RW-4A */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0__SIZE_1         4               /*       */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_UNIT            2:1             /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_UNIT_CYCLES     0x00000000      /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_UNIT_PACKETS    0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_UNIT_FLITS      0x00000002      /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_UNIT_BYTES      0x00000003      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER      7:3             /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER_INIT 0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER_HEAD 0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER_AE   0x00000002      /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER_BE   0x00000004      /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER_DATA 0x00000008      /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER_IDLE 0x00000010      /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_VCSETFILTERMODE 9:8             /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_VCSETFILTERMODE_INIT 0x00000003 /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_VCSETFILTERMODE_NONE 0x00000000 /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_VCSETFILTERMODE_VCSET0 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_VCSETFILTERMODE_VCSET1 0x00000002 /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE          19:17           /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_ONE      0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_TWO      0x00000001      /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_FOUR     0x00000002      /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_EIGHT    0x00000003      /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_SIXTEEN  0x00000004      /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_THIRTYTWO 0x00000005     /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_SIXTYFOUR 0x00000006     /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_ONETWENTYEIGHT 0x00000007 /* RW--V */

#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0(i)              (0x0000150c+(i)*0x54) /* RW-4A */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0__SIZE_1         4               /*       */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_UNIT            2:1             /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_UNIT_CYCLES     0x00000000      /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_UNIT_PACKETS    0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_UNIT_FLITS      0x00000002      /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_UNIT_BYTES      0x00000003      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER      7:3             /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER_INIT 0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER_HEAD 0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER_AE   0x00000002      /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER_BE   0x00000004      /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER_DATA 0x00000008      /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_FLITFILTER_IDLE 0x00000010      /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_VCSETFILTERMODE 9:8             /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_VCSETFILTERMODE_INIT 0x00000003 /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_VCSETFILTERMODE_NONE 0x00000000 /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_VCSETFILTERMODE_VCSET0 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_VCSETFILTERMODE_VCSET1 0x00000002 /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE          19:17           /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_ONE      0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_TWO      0x00000001      /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_FOUR     0x00000002      /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_EIGHT    0x00000003      /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_SIXTEEN  0x00000004      /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_THIRTYTWO 0x00000005     /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_SIXTYFOUR 0x00000006     /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_0_PMSIZE_ONETWENTYEIGHT 0x00000007 /* RW--V */

#define NV_NVLTLC_RX_SYS_CTRL_BUFFER_READY                    0x00000924      /* RW-4R */
#define NV_NVLTLC_RX_SYS_CTRL_BUFFER_READY_BUFFERRDY          0:0             /* RWEVF */
#define NV_NVLTLC_RX_SYS_CTRL_BUFFER_READY_BUFFERRDY_ENABLE   0x00000001      /* RW--V */
#define NV_NVLTLC_RX_SYS_CTRL_BUFFER_READY_BUFFERRDY_DISABLE  0x00000000      /* RWE-V */

#define NV_NVLTLC_TX_SYS_CTRL_BUFFER_READY                    0x00000124      /* RW-4R */
#define NV_NVLTLC_TX_SYS_CTRL_BUFFER_READY_BUFFERRDY          0:0             /* RWEVF */
#define NV_NVLTLC_TX_SYS_CTRL_BUFFER_READY_BUFFERRDY_ENABLE   0x00000001      /* RW--V */
#define NV_NVLTLC_TX_SYS_CTRL_BUFFER_READY_BUFFERRDY_DISABLE  0x00000000      /* RWE-V */

#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL                   0x00001508      /* RW-4R */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_ENTX0             0:0             /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_ENTX0_INIT        0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_ENTX1             1:1             /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_ENTX1_INIT        0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_ENTX2             2:2             /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_ENTX2_INIT        0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_ENTX3             3:3             /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_ENTX3_INIT        0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_RESETTX0          16:16           /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_RESETTX0_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_RESETTX1          17:17           /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_RESETTX1_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_RESETTX2          18:18           /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_RESETTX2_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_RESETTX3          19:19           /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_RESETTX3_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE0          24:24           /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE0_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE1          25:25           /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE1_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE2          26:26           /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE2_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE3          27:27           /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE3_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_HW_FORCE_ILA_TRIGGER_ENABLE 29:29 /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_HW_FORCE_ILA_TRIGGER_ENABLE_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_HW_FORCE_ILA_TRIGGER_ENABLE_DISABLE 0x00000000 /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_HW_TP_ENABLE      30:30           /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_HW_TP_ENABLE_ENABLE 0x00000001    /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_HW_TP_ENABLE_DISABLE 0x00000000   /* RWD-V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_HW_TP_CAPTURE_ENABLE 31:31        /* RWDVF */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_HW_TP_CAPTURE_ENABLE_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_TX_LNK_DEBUG_TP_CNTR_CTRL_HW_TP_CAPTURE_ENABLE_DISABLE 0x00000000 /* RWD-V */

#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL                   0x00001d08      /* RW-4R */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_ENRX0             0:0             /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_ENRX0_INIT        0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_ENRX1             1:1             /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_ENRX1_INIT        0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_ENRX2             2:2             /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_ENRX2_INIT        0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_ENRX3             3:3             /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_ENRX3_INIT        0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_RESETRX0          16:16           /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_RESETRX0_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_RESETRX1          17:17           /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_RESETRX1_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_RESETRX2          18:18           /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_RESETRX2_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_RESETRX3          19:19           /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_RESETRX3_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE0          24:24           /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE0_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE1          25:25           /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE1_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE2          26:26           /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE2_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE3          27:27           /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_CAPTURE3_INIT     0x00000000      /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_HW_TP_ENABLE      30:30           /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_HW_TP_ENABLE_ENABLE 0x00000001    /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_HW_TP_ENABLE_DISABLE 0x00000000   /* RWD-V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_HW_TP_CAPTURE_ENABLE 31:31        /* RWDVF */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_HW_TP_CAPTURE_ENABLE_ENABLE 0x00000001 /* RW--V */
#define NV_NVLTLC_RX_LNK_DEBUG_TP_CNTR_CTRL_HW_TP_CAPTURE_ENABLE_DISABLE 0x00000000 /* RWD-V */
#endif // __lr10_dev_nvltlc_ip_h__
